function [alpha] = cm_polarizability(perin, perout, a, kw)

% This function applies the Clausius-Mossoti relation attending to the
% electric or magentic response of the surrounding medium (perout) and the 
% electric or magnetic response of an inner medium (perin) and the mean
% separation between unit cells (a) and an incident wavenumber (kw).

%%%%%% INPUT ARGUMENTS %%%%%%
%%% perin:  inner permitTivity or permeability                     %%%
%%% perout: outer permittivity or permeability                     %%%
%%% a:      separation between dipoles given by the discretization %%%
%%% kw:     exciting wavenumber                                    %%%


Delta   = (perin*eye(3) - perout*eye(3))*(perin*eye(3) + ... 
    2*perout*eye(3))^(-1); %Polarizability tensor

alpha0  = (3*a^3/(4*pi))*Delta; %Volume correction

alpha = alpha0*(eye(3)-1i*alpha0*kw^3/(6*pi))^(-1); %% Radiative correction


%%%% This result must be multiplied by a correction factor depending on if
%%%% its an electric or magnetic polarizability.

end

